# 🚗 RidePool - Car Pooling & Ride Sharing Platform

**A Professional City-to-City Car Pooling Platform Built with Laravel & PHP**

---

## 📋 Project Overview

RidePool is a comprehensive car pooling and ride-sharing platform that connects drivers and passengers for city-to-city travel. The platform supports both seat booking (shared rides) and full car booking (private rides) with a professional, modern UI/UX.

### ✨ Key Features

- **Seat Sharing (Carpooling)**: Book individual seats in shared rides
- **Full Car Booking**: Book entire vehicle for private trips
- **Multi-Driver System**: Multiple drivers can offer rides simultaneously
- **City-to-City Travel**: Support for inter-city route management
- **Driver Verification**: Document verification system for drivers
- **Rating & Review System**: 5-star rating for both drivers and passengers
- **Payment Integration**: Support for multiple payment methods
- **Real-time Notifications**: Keep users informed about bookings and rides
- **Professional UI/UX**: Modern, responsive design with smooth animations

---

## 🏗️ Technical Stack

- **Backend**: Laravel 12.x (Latest)
- **Database**: MySQL
- **Frontend**: Blade Templates, AlpineJS, Tailwind CSS
- **Authentication**: Laravel Sanctum/Breeze
- **Payment**: Stripe/PayPal Integration (Ready)
- **Maps**: Google Maps API / Leaflet.js (Ready)

---

## 📁 Database Schema

### Tables Created:

1. **Users** - Extended with driver/passenger functionality, ratings, verification
2. **Vehicles** - Driver vehicles with type, capacity, and verification status
3. **Cities** - City database with coordinates for route calculation
4. **Routes** - City-to-city routes with distance, duration, and base pricing
5. **Rides** - Active rides with scheduling, pricing, and amenity information
6. **Bookings** - Passenger bookings (seat or full car) with payment tracking
7. **Payments** - Transaction records with multiple payment methods
8. **Reviews** - Driver and passenger rating system
9. **Notifications** - User notification system

### Key Relationships:

- Users → Vehicles (One-to-Many)
- Users → Rides as Driver (One-to-Many)
- Users → Bookings as Passenger (One-to-Many)
- Routes → Cities (Many-to-One for from/to)
- Rides → Routes, Vehicles, Drivers (Many-to-One)
- Bookings → Rides, Passengers (Many-to-One)
- Payments → Bookings (One-to-One)
- Reviews → Bookings (One-to-One)

---

## ✅ What's Been Completed

### Phase 1: Project Setup ✓
- [x] Laravel 12 installation
- [x] Project structure setup
- [x] Database configuration (MySQL)

### Phase 2: Database Layer ✓
- [x] All 9 migration files created
- [x] Complete database schema designed
- [x] Foreign key relationships established
- [x] All Eloquent models generated

### Files Created:
```
database/migrations/
├── 2025_12_17_161249_add_fields_to_users_table.php
├── 2025_12_17_161416_create_vehicles_table.php
├── 2025_12_17_162327_create_cities_table.php
├── 2025_12_17_162356_create_routes_table.php
├── 2025_12_17_162659_create_rides_table.php
├── 2025_12_17_162716_create_bookings_table.php
├── 2025_12_17_162755_create_payments_table.php
├── 2025_12_17_162812_create_reviews_table.php
└── 2025_12_17_162829_create_notifications_table.php

app/Models/
├── User.php (extended)
├── Vehicle.php
├── City.php
├── Route.php
├── Ride.php
├── Booking.php
├── Payment.php
├── Review.php
└── Notification.php
```

---

## 🚀 Next Steps

### Phase 3: Model Relationships & Logic
1. Add fillable fields and casts to all models
2. Define Eloquent relationships (hasMany, belongsTo, etc.)
3. Add model accessors and mutators
4. Create model scopes for common queries

### Phase 4: Authentication & Core Controllers
1. Install Laravel Breeze/Sanctum for authentication
2. Create driver registration flow
3. Build RideController for ride management
4. Build BookingController for booking management
5. Create SearchController for ride search with filters

### Phase 5: Frontend UI Development
1. **Landing Page**: Hero section, how it works, popular routes
2. **User Dashboard**: Booking history, profile management
3. **Driver Dashboard**: Vehicle management, ride creation, earnings
4. **Search Interface**: Advanced ride search with filters
5. **Booking Flow**: Seat selection, payment integration
6. **Review System**: Post-ride rating interface

### Phase 6: Advanced Features
1. Real-time notifications with Laravel Echo
2. Chat system between drivers and passengers
3. GPS integration for live tracking
4. Payment gateway integration (Stripe/PayPal)
5. Admin dashboard for platform management
6. Analytics and reporting

---

## 💻 Installation Instructions

### Prerequisites:
- PHP 8.2 or higher
- Composer
- MySQL 8.0+
- Node.js & NPM

### Setup Steps:

1. **Clone and Navigate to Project**
   ```bash
   cd d:\gg\ridepool
   ```

2. **Install Dependencies**
   ```bash
   composer install
   npm install
   ```

3. **Environment Configuration**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. **Configure Database**
   Edit `.env` file with database credentials:
   ```
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=ridepool
   DB_USERNAME=root
   DB_PASSWORD=your_password
   ```

5. **Create Database**
   ```sql
   CREATE DATABASE ridepool;
   ```

6. **Run Migrations**
   ```bash
   php artisan migrate
   ```

7. **Seed Database (Coming Soon)**
   ```bash
   php artisan db:seed
   ```

8. **Start Development Server**
   ```bash
   php artisan serve
   npm run dev
   ```

9. **Access Application**
   Open browser: `http://localhost:8000`

---

## 🎨 Design Principles

### UI/UX Guidelines:
- **Mobile-First**: Fully responsive design
- **Modern Aesthetics**: Vibrant colors, smooth gradients
- **Micro-Animations**: Engaging hover effects and transitions
- **Professional Typography**: Google Fonts (Inter, Roboto)
- **Accessibility**: WCAG compliant
- **Performance**: Fast load times, optimized assets

### Color Palette (Suggested):
- Primary: `#4F46E5` (Indigo)
- Secondary: `#10B981` (Emerald)
- Accent: `#F59E0B` (Amber)
- Background: `#F9FAFB` (Light Gray)
- Dark Mode: `#1F2937` (Dark Gray)

---

## 📊 Database ERD Overview

```
Users ─┬─> Vehicles ─> Rides
       ├─> Bookings ─┬─> Payments
       │             └─> Reviews
       └─> Notifications

Cities ─> Routes ─> Rides
```

---

## 🔐 Security Features

- Password hashing with bcrypt
- CSRF protection
- SQL injection prevention (Eloquent ORM)
- XSS protection
- Driver verification system
- Secure payment processing

---

## 📱 Platform Features in Detail

### For Passengers:
- Search rides by source/destination
- Filter by departure time, price, amenities
- Book seats or entire car
- View driver ratings and reviews
- Track ride status
- Make secure payments
- Rate drivers after ride

### For Drivers:
- Register and verify vehicles
- Create and manage rides
- Set pricing for seats and full car
- Manage bookings
- View earnings
- Track ratings and reviews
- Communicate with passengers

### For Admins:
- Platform overview and analytics
- User and driver management
- Verify driver documents
- Handle disputes
- Manage routes and cities
- Monitor platform health

---

## 📝 API Routes (Coming Soon)

```
GET    /api/rides/search          - Search available rides
GET    /api/rides/{id}            - Get ride details
POST   /api/bookings              - Create a booking
GET    /api/user/bookings         - Get user bookings
POST   /api/driver/rides          - Create a ride (driver)
GET    /api/driver/rides          - Get driver rides
POST   /api/reviews               - Submit a review
GET    /api/cities                - Get all cities
GET    /api/routes                - Get popular routes
```

---

## 🤝 Contributing

This is a professional car pooling platform project. Contributions are welcome!

---

## 📄 License

This project is proprietary software.

---

## 🎯 Project Status

**Current Phase**: ✅ Database Design Complete
**Next Milestone**: Model Relationships & Controllers
**Completion**: ~30% Complete

---

## 📞 Support

For questions or support, please contact the development team.

---

**Built with ❤️ using Laravel & Modern Web Technologies**

---

## Quick Start Command Reference

```bash
# Create database
mysql -u root -p -e "CREATE DATABASE ridepool"

# Run migrations
php artisan migrate

# Create seeders (upcoming)
php artisan db:seed

# Start server
php artisan serve

# Compile assets
npm run dev

# Create controller
php artisan make:controller RideController --resource

# Create seeder
php artisan make:seeder CitiesSeeder
```

---

**Next Steps**: Continue with model relationships and authentication setup!
